"""
HB_GuidesColor V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_GuidesColor
Description-US: Changes Color of all Guide Objects

Usage:
This Script opens a Colorchooser to select a Color. All Guides in the Project will receive this Color to be better seen in the Viewport.

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=30m22s

Name-DE: HB_GuidesColor
Description-DE: Ändert die Farbe von Hilfslinien

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon


"""

import c4d
from c4d import gui

def GetNextObject(op, stop_at=None):
    
    if op is None:
      return None

    if op.GetDown():
      return op.GetDown()

    while not op.GetNext() and op.GetUp() and op.GetUp() != stop_at:
      op = op.GetUp()

    return op.GetNext()


def GetAllObjects(first_obj, stop_at=None):


    if (first_obj is None) or (not first_obj.IsAlive()):
      return None

    objs = []

    cur_obj = first_obj
    while cur_obj is not None:
      objs.append(cur_obj)
      cur_obj = GetNextObject(cur_obj, stop_at=stop_at)

    return objs


def main():
    guidecolor = c4d.gui.ColorDialog(0)
    AllObjects = GetAllObjects(doc.GetFirstObject())
    for obj in AllObjects:
        
        if obj.GetType()==1027657:
            obj[c4d.ID_BASEOBJECT_USECOLOR]=True
            obj[c4d.ID_BASEOBJECT_COLOR]=guidecolor
        
    
    c4d.EventAdd()
    
    

if __name__=='__main__':
    main()
